// public/service-worker.js

// 'install' event - cache basic resources (optional, but good for performance)
self.addEventListener('install', (event) => {
  console.log('Service Worker installed successfully!');
  // Skip waiting and activate the new Service Worker immediately
  self.skipWaiting();
});

// 'activate' event - clean old caches
self.addEventListener('activate', (event) => {
  console.log('Service Worker activated successfully!');
  // Ensures the new Service Worker controls the page immediately
  clients.claim();
});

// The most important event: 'push'
// This is where the magic happens when the server sends a notification.
self.addEventListener('push', (event) => {
  console.log('Push received!');

  // Extract notification data. We expect a JSON from the server.
  const data = event.data.json();

  const title = data.title || 'AI Chatbot';
  const options = {
    body: data.body || 'You have a new message.',
    icon: '/images/icon-192x192.png', // Notification icon
    badge: '/images/icon-192x192.png', // Small icon (Android)
    vibrate: [100, 50, 100], // Vibration pattern
    data: {
      url: data.url || '/' // URL to open when clicking the notification
    }
  };

  // Display the notification
  event.waitUntil(self.registration.showNotification(title, options));
});

// 'notificationclick' event - what to do when the user clicks the notification
self.addEventListener('notificationclick', (event) => {
  event.notification.close(); // Close the notification

  // Open the URL defined in the notification data or the main page
  const urlToOpen = event.notification.data.url || '/user';
  event.waitUntil(clients.openWindow(urlToOpen));
});