// public/js/push-handler.js

const VAPID_PUBLIC_KEY = 'BIFjtk_kZcX0FHGtekt7eDaitPjjNoV44SLWLARhaqdl-DpID0Zv0_sKPYW3sLW05UtZnopCnG6WfrVKT2VPcJA'; // IMPORTANT!

/**
 * Converts the public key string to a format the browser understands.
 */
function urlBase64ToUint8Array(base64String) {
  const padding = '='.repeat((4 - base64String.length % 4) % 4);
  const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
  const rawData = window.atob(base64);
  const outputArray = new Uint8Array(rawData.length);
  for (let i = 0; i < rawData.length; ++i) {
    outputArray[i] = rawData.charCodeAt(i);
  }
  return outputArray;
}

/**
 * Main function to start the notification subscription process.
 */
async function subscribeUserToPush() {
  try {
    const registration = await navigator.serviceWorker.ready;
    const existingSubscription = await registration.pushManager.getSubscription();

    if (existingSubscription) {
      console.log('User is already subscribed.');
      // Optional: resend to backend to ensure it's synchronized
      // sendSubscriptionToBackend(existingSubscription);
      return;
    }

    const subscription = await registration.pushManager.subscribe({
      userVisibleOnly: true,
      applicationServerKey: urlBase64ToUint8Array(VAPID_PUBLIC_KEY),
    });

    console.log('New subscription created:', subscription);
    await sendSubscriptionToBackend(subscription);
  } catch (error) {
    console.error('Failed to subscribe to notifications:', error);
    if (Notification.permission === 'denied') {
        console.warn('Notification permission was denied.');
        // You can show a message to the user here if you want
    }
  }
}

/**
 * Sends the subscription object to our backend.
 */
async function sendSubscriptionToBackend(subscription) {
  try {
    const response = await authenticatedFetch('/api/push/subscribe', {
      method: 'POST',
      body: JSON.stringify({ subscription }),
      headers: {
        'Content-Type': 'application/json',
      },
    });

    if (response.ok) {
      console.log('Subscription sent to server successfully.');
    } else {
      const errorData = await response.json();
      throw new Error(errorData.error || 'Failed to send subscription');
    }
  } catch (error) {
    console.error('Error sending subscription to backend:', error);
  }
}

/**
 * Requests user permission and starts subscription.
 */
async function initializePushNotifications() {
    if (!('serviceWorker' in navigator) || !('PushManager' in window)) {
        console.warn('Push notifications are not supported in this browser.');
        return;
    }

    const permission = await Notification.requestPermission();
    if (permission === 'granted') {
        console.log('Notification permission granted.');
        await subscribeUserToPush();
    } else {
        console.log('Notification permission was not granted.');
    }
}