# Misayan - WhatsApp Chatbot System

Sistema completo de chatbot para WhatsApp com interface administrativa, gerenciamento de conversas, FAQ automático, integração com IA, e muito mais.

## 📋 Índice

- [Características](#-características)
- [Requisitos](#-requisitos)
- [Instalação](#-instalação)
- [Configuração](#-configuração)
- [Uso](#-uso)
- [Estrutura do Projeto](#-estrutura-do-projeto)
- [API Documentation](#-api-documentation)
- [Segurança](#-segurança)
- [Troubleshooting](#-troubleshooting)
- [Suporte](#-suporte)

## ✨ Características

- 🤖 **Chatbot Automático**: Respostas automáticas com FAQ e IA
- 💬 **Gerenciamento de Conversas**: Interface completa para gerenciar conversas do WhatsApp
- 📊 **Dashboard**: Métricas e estatísticas em tempo real
- 👥 **Multi-usuário**: Sistema de usuários com permissões
- 📱 **Interface Responsiva**: Design moderno e mobile-first
- 🔒 **Segurança**: Rate limiting, CSRF protection, XSS protection, e muito mais
- 🌐 **Multi-idioma**: Sistema de traduções integrado
- 📤 **Mensagens em Massa**: Envio de mensagens para múltiplos contatos
- 💳 **Integração de Pagamentos**: PayPal e PagSeguro
- 🔔 **Notificações Push**: Notificações web push para novos mensagens

## 📦 Requisitos

- **Node.js**: v16.0.0 ou superior
- **MySQL**: 8.0 ou superior
- **npm**: v7.0.0 ou superior
- **PM2** (opcional): Para produção

## 🚀 Instalação

### 1. Clone o repositório

```bash
git clone <repository-url>
cd misayan-chatbot
```

### 2. Instale as dependências

```bash
npm install
```

### 3. Configure o banco de dados

Crie um banco de dados MySQL:

```sql
CREATE DATABASE misayan_chatbot CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 4. Configure as variáveis de ambiente

Crie um arquivo `.env` na raiz do projeto:

```env
# Database Configuration
DB_HOST=localhost
DB_PORT=3306
DB_USER=root
DB_PASS=your-password
DB_NAME=misayan_chatbot

# JWT Secret (REQUIRED - Generate a strong random string)
# Generate with: node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"
JWT_SECRET=your-super-secret-jwt-key-change-this-in-production

# Server Configuration
PORT=7000
NODE_ENV=development

# OpenAI Configuration (Optional)
ENABLE_OPENAI=false
OPENAI_API_KEY=your-openai-api-key-here

# Web Push Notifications (Optional)
VAPID_PUBLIC_KEY=your-vapid-public-key
VAPID_PRIVATE_KEY=your-vapid-private-key
```

### 5. Inicie o servidor

**Desenvolvimento:**
```bash
npm run dev
```

**Produção:**
```bash
npm start
```

**Com PM2:**
```bash
npm run pm2:start
```

### 6. Acesse o sistema

Abra seu navegador em: `http://localhost:7000`

**Credenciais padrão:**
- Username: `admin`
- Password: `password`

⚠️ **IMPORTANTE**: Altere a senha padrão após o primeiro login!

## ⚙️ Configuração

### Configuração do WhatsApp

1. Acesse o painel administrativo
2. Vá para a seção de configurações do WhatsApp
3. Escaneie o QR Code exibido
4. Aguarde a conexão ser estabelecida

### Configuração de FAQ

1. Acesse o painel administrativo
2. Vá para "FAQ Management"
3. Adicione perguntas e respostas
4. Configure emojis e tempos de resposta

### Configuração de IA

1. Acesse "AI Configuration"
2. Configure sua API key (DeepSeek ou OpenAI)
3. Ajuste o comportamento da IA
4. Configure horários de funcionamento

## 📖 Uso

### Gerenciamento de Conversas

- Visualize todas as conversas na interface principal
- Atribua conversas para usuários específicos
- Responda mensagens diretamente pela interface
- Visualize histórico completo de mensagens

### Mensagens em Massa

1. Acesse "Mass Messages"
2. Crie grupos de contatos
3. Componha sua mensagem
4. Agende ou envie imediatamente

### Dashboard

O dashboard exibe:
- Mensagens do dia
- Contatos únicos
- Estatísticas por hora
- Status das conversas
- Gráficos de atividade

## 📁 Estrutura do Projeto

```
misayan-chatbot/
├── config/              # Configurações
│   ├── database.js      # Configuração do banco de dados
│   └── init-translations.js
├── controllers/         # Controllers (lógica de negócio)
│   ├── BaseController.js
│   ├── AuthController.js
│   └── DashboardController.js
├── middleware/          # Middlewares
│   ├── auth.js         # Autenticação JWT
│   ├── security.js     # Rate limiting, sanitização
│   ├── csrf.js         # Proteção CSRF
│   └── errorHandler.js # Tratamento de erros
├── routes/             # Rotas da API
│   ├── auth.js
│   ├── admin.js
│   ├── chat.js
│   └── ...
├── services/           # Serviços
│   ├── whatsappService.js
│   ├── aiService.js
│   └── ...
├── public/            # Arquivos estáticos
│   ├── admin/        # Interface administrativa
│   ├── user/         # Interface do usuário
│   ├── css/          # Estilos
│   └── js/           # JavaScript
├── uploads/          # Arquivos enviados
├── sessions/         # Sessões do WhatsApp
├── server.js         # Entry point
└── package.json      # Dependências
```

## 🔌 API Documentation

### Autenticação

#### POST /api/auth/login
Login de usuário

**Request:**
```json
{
  "username": "admin",
  "password": "password"
}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "token": "jwt-token-here",
    "user": {
      "id": 1,
      "username": "admin",
      "role": "admin",
      "store": ""
    }
  }
}
```

#### GET /api/auth/verify
Verificar validade do token

**Headers:**
```
Authorization: Bearer <token>
```

#### POST /api/auth/logout
Logout (remove token no cliente)

### Dashboard

#### GET /api/admin/dashboard
Obter métricas do dashboard (requer autenticação admin)

**Headers:**
```
Authorization: Bearer <token>
```

**Response:**
```json
{
  "success": true,
  "data": {
    "todayMessages": 150,
    "uniqueContacts": 45,
    "hourlyStats": [...],
    "conversationStats": [...],
    "dailyMessages": [...]
  }
}
```

## 🔒 Segurança

O sistema implementa várias camadas de segurança:

- ✅ **Rate Limiting**: Proteção contra brute force e abuso de API
- ✅ **Helmet.js**: Headers de segurança HTTP
- ✅ **XSS Protection**: Sanitização automática de inputs
- ✅ **CSRF Protection**: Tokens CSRF para formulários
- ✅ **JWT Authentication**: Autenticação baseada em tokens
- ✅ **SQL Injection Protection**: Prepared statements em todas as queries
- ✅ **Input Validation**: Validação centralizada de todos os inputs

O sistema implementa múltiplas camadas de segurança para proteção contra ataques comuns.

## 🐛 Troubleshooting

### Erro: "JWT_SECRET environment variable is required"

**Solução**: Adicione `JWT_SECRET` no arquivo `.env`:
```env
JWT_SECRET=your-secret-key-here
```

### Erro de conexão com banco de dados

**Solução**: Verifique as credenciais no `.env` e certifique-se de que o MySQL está rodando.

### QR Code não aparece

**Solução**: 
1. Verifique se a pasta `sessions/` existe e tem permissões de escrita
2. Limpe a pasta `sessions/` e tente novamente
3. Verifique os logs do servidor para mais detalhes

### Erro: "Too many requests"

**Solução**: Você atingiu o limite de rate limiting. Aguarde alguns minutos ou ajuste os limites em `middleware/security.js`.

## 📞 Suporte

Para suporte e dúvidas:
- Consulte a documentação completa
- Verifique os arquivos de log em `logs/`
- Revise os arquivos de configuração

## 📄 Licença

[Especificar licença aqui]

## 🔄 Changelog

### v1.0.0
- Versão inicial
- Sistema completo de chatbot
- Interface administrativa
- Integração com IA
- Sistema de segurança implementado

---

**Desenvolvido com ❤️ para facilitar o atendimento ao cliente via WhatsApp**

