# Installation Guide

## Quick Start

1. **Install Dependencies**
   ```bash
   npm install
   ```

2. **Configure Environment**
   - Copy `.env.example` to `.env`
   - Update database credentials
   - Generate JWT_SECRET: `node -e "console.log(require('crypto').randomBytes(32).toString('hex'))"`

3. **Start Server**
   ```bash
   npm start
   ```

4. **Access Application**
   - Open: `http://localhost:7000`
   - Default credentials: `admin` / `password`

## Production Setup

1. **Install PM2**
   ```bash
   npm install -g pm2
   ```

2. **Start with PM2**
   ```bash
   npm run pm2:start
   ```

3. **Monitor**
   ```bash
   pm2 monit
   ```

## Requirements

- Node.js 16+
- MySQL 8+
- npm 7+

## Common Warnings (Not Errors)

### VAPID Keys Warning
```
⚠️ VAPID keys not found. Push notifications are disabled.
```

**This is NOT an error** - It's just an informational message indicating that push notification keys are not configured. The system works perfectly without them.

**To enable push notifications (optional):**
1. Generate VAPID keys:
   ```bash
   npx web-push generate-vapid-keys
   ```
2. Add to `.env`:
   ```env
   VAPID_PUBLIC_KEY=your-public-key
   VAPID_PRIVATE_KEY=your-private-key
   ```

### ExperimentalWarning (JSON Modules)
```
ExperimentalWarning: Importing JSON modules is an experimental feature
```

**This is NOT an error** - It's a Node.js warning about experimental features used by dependencies (Baileys). The system works normally.

**This warning is already suppressed** in `ecosystem.config.js` with `--no-warnings` flag when using PM2.

## Troubleshooting

### Server won't start
- Check if `JWT_SECRET` is set in `.env`
- Verify database credentials
- Ensure all dependencies are installed: `npm install`

### Module not found errors
- Run `npm install` to install all dependencies
- Check if `package.json` has all required packages

